<?php

namespace App\Models\Product;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ProductCategory extends Model 
{

    protected $table = 'products_categories';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function abstracts()
    {
        return $this->morphMany('App\Models\Product\ProductAbstraction', 'abstractable');
    }

    public function products()
    {
        return $this->hasMany('App\Models\Product\Product', 'product_category_id');
    }

}